/* fxText.java Version 1.1
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 * Version 1.1 features a workaround for the sluggish showDocument() method.
 *
 ***************************************************************************
 * Abstract
 * --------
 * Uses transparency in GIF images to create a special effect.
 *
 * The BACKGROUND parameter references a GIF background texture or image
 * tile, which ideally should be smaller than the image to be displayed and
 * should be saved WITHOUT any transparency info.
 *
 * The FOREGROUND parameter references the GIF, with transparent elements
 * that will reveal the moving background. This GIF should be saved WITH
 * transparency information. The applets HEIGHT and WIDTH parameters must
 * specify the dimensions of this GIF.
 *
 * The HYPERLINK parameter should specify an URL, which will be called if the
 * mouse is clicked within the applet. Note that this does not function very
 * well for some reason... there is a LONG delay between clicking and the
 * actual link that is unacceptable.
 *
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.applet.*;
import java.awt.*;
import java.net.*;

import imageLoader;


public class fxText extends Applet implements Runnable
{
    int width,height;
    String[] szImages= new String[2];
    Image images[]= new Image[2];

    Image virtualImage=null;
    Graphics virtualGC=null;

    Image offscrImage=null;
    Graphics offscrImageGC=null;

    Thread kicker=null;

    imageLoader il=null;

    int X, Y;

    boolean allOK=true;

    URL link=null;



    public void init()
    {

        width=size().width;
        height=size().height;



        virtualImage=createImage(width*2,height*2);
        virtualGC=virtualImage.getGraphics();

        offscrImage=createImage(width, height);
        offscrImageGC=offscrImage.getGraphics();

        System.out.println("fxText Applet Copyright(C)1996 by Bill Giel");

        szImages[0] = getParameter("BACKGROUND");
        if(null == szImages[0]){
            System.out.println("fxText Error: No background parameter.");
            allOK=false;
        }

        szImages[1] = getParameter("FOREGROUND");
        if(null == szImages[1]){
            System.out.println("fxText Error: No foreground parameter.");
            allOK=false;
        }

        String param = getParameter("HYPERLINK");
        if(null != param){
            try{
                link=new URL(getCodeBase(),param);
            } catch(MalformedURLException e)
                {System.out.println("fxText Error: Malformed URL");link=null;}
        }

        if(allOK){
            il=new imageLoader(this,szImages,2,null);
            il.start();
        }

        X=Y=0;
        images=null;

    }


    public void start()
    {
        if(kicker == null){
            kicker = new Thread(this);
            kicker.start();
        }

    }

    public void stop()
    {
        if(null != kicker){
            kicker.stop();
            kicker=null;
        }
    }

    public boolean handleEvent(Event e)
    {
        if(e.id == Event.MOUSE_DOWN){

            if(null != link){

                getAppletContext().showDocument(link);
                
                //This is Netscapes official workaround for the
                //sluggish showDocument() method.
                for(int i=0;i<30;i++)
                    showStatus(link.toString());
                    
                return true;
            }
        }
        return super.handleEvent(e);
    }


    public void run()
    {
        if(allOK && null != il){
            Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

            while(null==(images=il.retrieveImages()));

            int tileWidth   =   images[0].getWidth(this);
            int tileHeight  =   images[0].getHeight(this);
            int xTiles      =   width/tileWidth;
            int yTiles      =   height/tileHeight;

            for(int y=0; y < virtualImage.getHeight(this); y = y + tileHeight)
                for(int x=0; x < virtualImage.getWidth(this); x = x + tileWidth)
                    virtualGC.drawImage(images[0], x, y, this);


            while(null != kicker){

                try{
                    Thread.sleep(50);
                }catch(InterruptedException e){}
                if( -(--X) > ((0 == xTiles)? width : xTiles*tileWidth)) X = 0;
                if( -(--Y) > ((0 == yTiles)? height : yTiles*tileHeight)) Y = 0;
                repaint();
            }
        }
        else repaint();
    }

    public void paint(Graphics g)
    {

        if(null==images){

            if(allOK)g.drawString("Loading Images...", 5, height/2);
            else    g.drawString("Error - No images!", 5, height/2);
        }
        else
            update(g);

    }

    public void update(Graphics g)
    {
        if(null != images){
            offscrImageGC.drawImage(virtualImage, X, Y, this);
            offscrImageGC.drawImage(images[1],0,0,this);
            g.drawImage(offscrImage,0,0,this);

        }
    }
}
